/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  lcd.c
*  :  XuQP
*  :  V1.0
*  :  2020/3/11
*  :  VGEN LCD
          1.IOֱʽLCD
          2.5V 1/4 1/2ƫõĶʽLCD
          3.COMҪ1/2VDD PBֵͬƼΪCOM
*  ע:  ES7H202x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

void RAMClear(void);
void Delay1ms(unsigned int time);
void LcdDriver(void);

#define COM1	PA0
#define COM2	PA1
#define COM3	PA2
#define COM4	PA3

#define SEG1	PE0
#define SEG2	PE1
#define SEG3	PE2
#define SEG4	PE3
#define SEG5	PE4
#define SEG6	PE5

unsigned char m_u8Step;   //comɨ 0-7

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{  
    RAMClear();           //RAM

    PAS = 0x00;           
	PAT |= 0b00001111;    //comΪ룬1/2VDD
	PAPU = 0x0F;          //
	PAPD = 0x0F;          //

	PES = 0x00;           
	PE  = 0x00;
	PET = 0x00;           //segΪ

    while(1)
	{
		Delay1ms(2);      //ʱԼ2msлcom
		LcdDriver();      //ˢLCDʾ
	}
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}


/*********************************************************
: void Delay1ms(unsigned int time)
  : ʱӳ, ѭʱ16MHz£ÿΪ125ns
ֵ: timeʱλ1ms
ֵ: 
ֵ:  
**********************************************************/
void Delay1ms(unsigned int time)
{
    unsigned int i, j, k;

    for (i=0; i<time; i++)
    {
        for (j=0; j<5; j++)
        {
            for (k=0; k<95; k++)
            {
                __Asm NOP;
                __Asm NOP;
                __Asm NOP;
            }
        }
    }
}

/*********************************************************
: void LcdDriver(void)
  : ˢLCDʾѭѡcom0~com4seg
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void LcdDriver(void)
{
	m_u8Step++;          //comɨ˳ÿcomӦ2step
	if (m_u8Step >= 8)
	{
		m_u8Step = 0;
	}
   
   	PAT |= 0b00001111;   //COMΪ룬1/2VDD
	PAPU = 0x0F;
	PAPD = 0x0F;

	switch(m_u8Step)
	{
		case 0://com1ߵƽ
				COM1 = 1;
				PAT &= 0b00001110;
				break;
		case 1://com1͵ƽ
				COM1 = 0;	
				PAT &= 0b00001110;
				break;				
		case 2://com2ߵƽ
				COM2 = 1;	
				PAT &= 0b00001101;
				break;
		case 3://com2͵ƽ
				COM2 = 0;	
				PAT &= 0b00001101;
				break;
		case 4://com3ߵƽ
				COM3 = 1;	
				PAT &= 0b00001011;
				break;
		case 5://com3͵ƽ
				COM3 = 0;	
				PAT &= 0b00001011;
				break;
		case 6://com4ߵƽ
				COM4 = 1;	
				PAT &= 0b00000111;
				break;
		case 7://com4͵ƽ
				COM4 = 0;	
				PAT &= 0b00000111;
				break;
        default:
                break;
	}
	if (m_u8Step < 8)
	{
		if(m_u8Step %2==1)  //comΪ0segΪ1seg
		{
			SEG1 = 1;
			SEG2 = 1;
			SEG3 = 1;
            SEG4 = 1;
			SEG5 = 1;
			SEG6 = 1;
		}
		else                //comΪ1segΪ0seg
		{
			SEG1 = 0;
			SEG2 = 0;
			SEG3 = 0;
            SEG4 = 0;
			SEG5 = 0;
			SEG6 = 0;
		}
	}
}